/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_TRACKWAYPOINT_HH
#define TOP10_TRACKWAYPOINT_HH

#include "math/Vertex.hh"

namespace top10 {
namespace track {

//! Indicate the direction and banking of the road at some point
class Waypoint {
public:
  Waypoint();

  ~Waypoint();

  inline void setPos(const top10::math::Vector& theValue)
  {
    pos = theValue;
  }
  
  inline top10::math::Vector getPos() const
  {
    return pos;
  }

  inline void setTangent(const top10::math::Vector& theValue)
  {
    tangent = theValue;
  }
  
  inline top10::math::Vector getTangent() const
  {
    return tangent;
  }

  /*! \param theValue angle in degrees */
  inline void setBankAngle(float theValue)
  {
    bank_angle = theValue;
  }
  
  inline float getBankAngle() const
  {
    return bank_angle;
  }

private:
   top10::math::Vector pos;
   top10::math::Vector tangent;
   float bank_angle;
};

}
}

#endif
