/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/


#ifndef TOP10_TRACKTEXTURESPEC_HH
#define TOP10_TRACKTEXTURESPEC_HH

#include <string>
#include "util/XmlDumpable.hh"

namespace top10 {
namespace track {

//! Specify a texture mapping.
/*! Consists of a picture filename and 2d transformations.
*/
class TextureSpec: public top10::util::XmlDumpable
{
protected:
  //! Needed for children, to override the xml node value.
  TextureSpec(const std::string&);

public:
  TextureSpec();
  ~TextureSpec();

  // Implementation of XmlDumpable
  void clearState();
  int loadXml(const TiXmlElement*);
  int saveXml(TiXmlElement*) const;

  std::string getFilename() const;
  double getScaleLat() const;
  double getScaleLong() const;
  double getTranslateLat() const;
  double getTranslateLong() const;

  void setFilename(const std::string& name);
  void setScaleLat(double);
  void setScaleLong(double);
  void setTranslateLat(double);
  void setTranslateLong(double);

private:
  //! The name of the texture
  std::string filename;
  //! Scale factor
  double scale_lat;
  double scale_long;
  //! Texture translation
  double translate_lat;
  double translate_long;
};

}
}

#endif
