/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "TextureSpec.hh"

namespace top10 {
namespace track {

TextureSpec::TextureSpec():
top10::util::XmlDumpable("texture")
{
  clearState();
}

TextureSpec::~TextureSpec()
{
}

void TextureSpec::clearState()
{
  filename = "";
  scale_lat = 1.0;
  scale_long = 1.0;
  translate_lat = 0.0;
  translate_long = 0.0;
}

void TextureSpec::setFilename(const std::string& name)
{
  filename = name;
}

void TextureSpec::setTranslateLat(double x)
{
  translate_lat = x;
}

void TextureSpec::setTranslateLong(double x)
{
  translate_long = x;
}

void TextureSpec::setScaleLat(double x)
{
  scale_lat = x;
}

void TextureSpec::setScaleLong(double x)
{
  scale_long = x;
}

std::string TextureSpec::getFilename() const
{
  return filename;
}

double TextureSpec::getTranslateLat() const
{
  return translate_lat;
}

double TextureSpec::getTranslateLong() const
{
  return translate_long;
}

double TextureSpec::getScaleLat() const
{
  return scale_lat;
}

double TextureSpec::getScaleLong() const
{
  return scale_long;
}

int TextureSpec::loadXml(const TiXmlElement* el)
{
  assert(el);
  int ret = 0;

  const char* p = el->Attribute("texture");
  if (p) filename = p;
  else logXmlNodeError("Missing texture attribute", el, top10::util::Log::Warning);

  int s = el->QueryDoubleAttribute("scale_lat", &scale_lat);
  if (s) { ret = s; logXmlNodeError("Missing attribute scale_lat or wrong type", el, top10::util::Log::Warning); }

  s = el->QueryDoubleAttribute("scale_long", &scale_long);
  if (s) { ret = s; logXmlNodeError("Missing attribute scale_long or wrong type", el, top10::util::Log::Warning); }

  s = el->QueryDoubleAttribute("translate_lat", &translate_lat);
  if (s) { ret = s; logXmlNodeError("Missing attribute translate_lat or wrong type", el, top10::util::Log::Warning); }

  s = el->QueryDoubleAttribute("translate_long", &translate_long);
  if (s) { ret = s; logXmlNodeError("Missing attribute translate_long or wrong type", el, top10::util::Log::Warning); }

  return ret;
}

int TextureSpec::saveXml(TiXmlElement* el) const
{
  assert(el);

  el->SetAttribute("texture", filename);
  el->SetDoubleAttribute("scale_lat", scale_lat);
  el->SetDoubleAttribute("scale_long", scale_long);
  el->SetDoubleAttribute("translate_lat", translate_lat);
  el->SetDoubleAttribute("translate_long", translate_long);
  return 0;
}

}
}
