/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_TRACK_OUTLINEVERTEX_HH
#define TOP10_TRACK_OUTLINEVERTEX_HH

#include "math/Vertex.hh"
#include "TrackTriangulation.hh"
#include "AreaCoord.hh"

#include <vector>

namespace top10
{
  namespace track
  {

    //! Used to generate constraints in the triangulation.
    /*! This class is used to generate a vertex in a constraint. */
    struct OutlineVertex
    {
      top10::math::Vector center;   //!< The point on the hermite curve which generates this vertex
      top10::math::Vector normal;   //!< The vector from center to this vertex
      double u;	  //!< Used for texture mapping or the road and its surrounding
      double v;	  //!< Used for texture mapping of the road and its surrounding, lateral distance

      std::vector<AreaCoord> coords;
    };

    //! Used to generate a constraint in the triangulation.
    typedef std::vector<OutlineVertex> Outline;

    //! Build a closed polygon from normals and centers
    std::vector<TexturedVertex> makeConstraints(const Outline& outline);
  
    //! Remove points from an outline which cause the outline to cross itself
    void removeCrossings(Outline&);  

    //! Given two intersecting outlines, generate a non-intersecting outline.
    /*!
      \param prev The first intersecting outline
      \param current The current intersecting outline
      \param final The prefix of prev (up to the intersection point) is moved to final

      Upon return, the tail of current is moved to prev, current becomes empty.
    */
    void mergeOutlines(Outline& prev, Outline& current, Outline& final);
  }
}

#endif
