/*
  Top 10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_TRACK_AREACOORD_HH
#define TOP10_TRACK_AREACOORD_HH

#include "TextureSpec.hh"
#include "SurfaceTypeEnum.hh"

namespace top10 {
  namespace track {

    //! Texturing and surface information for a vertex.
    struct AreaCoord
    {
      AreaCoord(): s(0.0), t(0.0), texture(0), surf_type(Road) {}
      AreaCoord(double s, double t): s(s), t(t), texture(0), surf_type(Road) {}

      inline bool operator==(const AreaCoord& other) const
      {
	return s == other.s && t == other.t && texture == other.texture;
      }

      //! The name of the material of triangles of the road
      static inline std::string getRoadMaterialName() { return "Road"; }
      //! The name of the material of triangles of grass
      static inline std::string getGrassMaterialName() { return "Grass"; }

      double s;
      double t;
      const TextureSpec* texture;    //!< Points to a TextureSpec owned by the SectionsEditor
      SurfaceTypeEnum surf_type;     //!< The type of the surface. Used for loose matching.
    };

    //! Match an AreaCoord by its TextureSpec
    struct AreaCoordFind
    {
      AreaCoordFind(const TextureSpec* spec): spec(spec) {}
      inline bool operator()(const AreaCoord& c) const { return c.texture == spec; }

      const TextureSpec* spec;
    };

    //! Match AreaCoords according to the type of surface (grass, road...)
    struct LooseAreaCoordFind
    {
      LooseAreaCoordFind(SurfaceTypeEnum surf_type): surf_type(surf_type) {}
      inline bool operator()(const AreaCoord& c) const { return c.surf_type == surf_type; }

      SurfaceTypeEnum surf_type;
    };

  }
}

#endif
