/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_ENGINE_TEST_DLG_H
#define TOP10_ENGINE_TEST_DLG_H

#include "physX/KartState.hh"

#include "EngineTestDlgSkel.hh"
#include <QtCore/QTimerEvent>
#include <QtGui/QDialog>

class EngineTestDlg : public QDialog, public Ui_EngineTestDlgSkel
{
  Q_OBJECT

public:
  static const int TIMER_PERIOD = 100;
  static const int UPDATE_PERIOD = 10;

  EngineTestDlg(QWidget* parent =0);

private:
  void timerEvent(QTimerEvent*);
  void update(double t, double dt);

private slots:
  void on_m_clutch_engaged_toggled(bool b);
  void on_m_gear_valueChanged(int);
  void on_m_throttle_valueChanged(int);
  void on_m_start_stop_pressed();
  void on_m_wheel_inertia_editingFinished();

private:
  top10::util::Ref<top10::physX::KartProperties> m_props;
  top10::physX::KartState m_kart;
  double m_wheel_inertia_val;
  double m_time;
  int m_timer_id;
};

#endif
