/*
  Top10, a racing simulator
  Copyright (C) 2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_SOUND_SKIDDING_HH
#define TOP10_SOUND_SKIDDING_HH

#include <AL/al.h>
#include <vector>

#include "util/XmlDumpable.hh"
#include "util/RefCount.hh"

namespace top10 
{
  namespace sound
  {
    /*! Model of a skidding sound.
        The sound volume is controlled by the amount of load. The pitch is unmodified.
	No sound should be emitted below a certain friction level.

	The load should be expressed in Newtons, Kilograms or any other force or mass unit.
	It can be negative.

	The friction can be a speed, an angle or a ratio. It is expected to be positive.
	*/
    class SkiddingSound: public top10::util::XmlDumpable, public top10::util::RefCount
    {
    public:
      SkiddingSound();

      void setBuffer(ALuint);
      ALuint getBuffer() const;
      void setMinLoad(float);
      void setMaxLoad(float);
      float getMinLoad() const;
      float getMaxLoad() const;
      void setMinFriction(float);
      float getMinFriction() const;

    protected:
      // XmlDumpable implementation
      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

    private:
      ALuint al_buf;
      float min_load;
      float max_load;
      float min_friction;
   };

    typedef top10::util::Ref< SkiddingSound > SkiddingSoundRef;
    typedef std::vector< SkiddingSoundRef > SkiddingSoundRefs;

   SkiddingSound* buildSkiddingSound();
   SkiddingSound* buildSideSkiddingSound();
  }
}

#endif
