/*
  Top10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_SOUND_ROLLING_INSTANCE_HH
#define TOP10_SOUND_ROLLING_INSTANCE_HH

#include "RollingSound.hh"
#include "SourceAllocator.hh"
#include "math/Vertex.hh"

namespace top10
{
  namespace sound
  {
    class RollingSoundInstance: public top10::util::RefCount, private top10::util::NoCopy
    {
    public:
      RollingSoundInstance(RollingSound*, SourceAllocator*);

      void setEnabled(bool);
      void update(float delta_s, const top10::math::Vector& pos, const top10::math::Vector& speed);

      void unmute();
      void mute();

    private:
      top10::util::Ref<const RollingSound> model;
      SourceAllocatorRef source_alloc;
      SourceRef rolling_source;
      SourceRefs pebble_sources;
      std::vector<float> pebble_freqs;
      bool enabled;
    };

    typedef top10::util::Ref< RollingSoundInstance > RollingSoundInstanceRef;
    typedef std::vector< RollingSoundInstanceRef > RollingSoundInstanceRefs;
  }
}
#endif
