/*
  Top10, a racing simulator
  Copyright (C) 2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "RollingSound.hh"
#include "BufferManager.hh"
#include "util/PathFinder.hh"

top10::sound::RollingSound::RollingSound()
: min_speed(-1.0), max_speed(-1.0), rolling_buf(0)
{
}

void top10::sound::RollingSound::setMainBuffer(ALuint buf, float m, float M)
{
  min_speed = m;
  max_speed = M;
  rolling_buf = buf;
}

ALuint top10::sound::RollingSound::getMainBuffer() const
{
  assert(min_speed >= 0.0);
  return rolling_buf;
}

float top10::sound::RollingSound::getMinSpeed() const
{
  assert(min_speed >= 0.0);
  return min_speed;
}

float top10::sound::RollingSound::getMaxSpeed() const
{
  assert(min_speed >= 0.0);
  return max_speed;
}

void top10::sound::RollingSound::addPebbleBuffer(ALuint buf, float hits_per_meter)
{
  PebbleHit p = {buf, hits_per_meter};
  pebbles.push_back(p);
}

bool top10::sound::RollingSound::getPebble(int idx, ALuint& buf, float& freq) const
{
  if (idx < 0 || idx >= pebbles.size())
    return false;

  buf = pebbles.at(idx).buf;
  freq = pebbles.at(idx).hits;
  return true;
}

top10::sound::RollingSound*
top10::sound::makeRollingSound()
{
  RollingSound* ret = new RollingSound;

  std::string path = top10::util::PathFinder::defaultPathFinder().find("rolling.wav");
  if (path.empty())
    path = "rolling.wav";

  ALuint buf = BufferManager::getSingle()->load(path);
  ret->setMainBuffer(buf, 10.0, 30.0);

  path = top10::util::PathFinder::defaultPathFinder().find("tic.wav");
  if (!path.empty())
  {
    buf = BufferManager::getSingle()->load(path);
    ret->addPebbleBuffer(buf, 0.1);
  }

#if 0
  path = top10::util::PathFinder::defaultPathFinder().find("tac.wav");
  if (!path.empty())
  {
    buf = BufferManager::getSingle()->load(path);
    ret->addPebbleBuffer(buf, 0.5);
  }
#endif

  return ret;
}
