/*
  Top10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "Listener.hh"
#include <AL/al.h>

namespace top10
{
  namespace sound
  {
    Listener::Listener()
      : gain(1.0)
    {
    }

    void Listener::setALState()
    {
      alListenerf(AL_GAIN, gain);
      alListener3f(AL_POSITION, view.getCenter().x, view.getCenter().y, view.getCenter().z);
#if SOUND_VELOCITY_DISABLED
      alListener3f(AL_VELOCITY, 0.0, 0.0, 0.0);
#else
      alListener3f(AL_VELOCITY, speed.x, speed.y, speed.z);
#endif
      float v[6] = {
	view.getDirection().x, view.getDirection().y, view.getDirection().z,
	view.getUp().x, view.getUp().y, view.getUp().z
      };
      alListenerfv(AL_ORIENTATION, v);
    }

    void Listener::setGain(float f)
    {
      gain = f;
    }

    void Listener::setView(const top10::math::Frustum& v)
    {
      view = v;
    }

    void Listener::setSpeed(const top10::math::Vector& v)
    {
      speed = v;
    }
  }
}
