/*
  Top10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_SOUND_BUFFER_MANAGER_HH
#define TOP10_SOUND_BUFFER_MANAGER_HH

#include <AL/al.h>
#include <map>
#include "util/RefCount.hh"
#include "util/NoCopy.hh"

namespace top10
{
  namespace sound
  {
    class BufferManager: public top10::util::RefCount, private top10::util::NoCopy
    {
    public:
      struct BadId {};

    public:
      ~BufferManager();

      ALuint load(const std::string path);
      std::string lookup(ALuint) const;

      static BufferManager* getSingle();

    private:
      std::map<std::string, ALuint> buffers;

      /* FIXME: A singleton is a very bad idea here.
      We may only execute the destructor as long as the OpenAL context is
      valid, but we don't know when (if) the singleton is destructed.

      Possible fixes: Don't use singletons, or use a singleton gathering
      all OpenAL-related singletons, making it easier to destruct them in
      the right order if they get destructed.
      */
      static top10::util::Ptr<BufferManager> single;
    };

    typedef top10::util::Ref< BufferManager > BufferManagerRef;
    typedef std::vector< BufferManagerRef > BufferManagerRefs;
  }
}
#endif
