/*
  Top10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef _TOP10_AUDIO_CONTEXT_HH
#define _TOP10_AUDIO_CONTEXT_HH

#include <AL/al.h>
#include <AL/alc.h>
#include <string>

#include "util/error.hh"
#include "util/RefCount.hh"
#include "util/NoCopy.hh"

namespace top10
{
  namespace sound
  {
    //! Class keeping track of the audio context.
    class AudioContext: public top10::util::RefCount, private top10::util::NoCopy
    {
    public:
      class Error: public top10::util::Error
      {
      public:
	Error(const std::string& msg);
      };

    public:
      /*!
        Build a context using an optional specic device, or the default device.
	\throw Error Failed to open device and create a context.
      */
      AudioContext(const char* device_name = 0);
      ~AudioContext();

    private:
      ALCdevice* dev;
      ALCcontext* context;
    };

    typedef top10::util::Ref< AudioContext > AudioContextRef;
    typedef std::vector< AudioContextRef > AudioContextRefs;

    //! A function generating a string from an ALenum indicating an error (or no error).
    std::string makeErrorStr(ALenum);
  };
};

#endif
