/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef STARTING_AREA_HH
#define STARTING_AREA_HH

#include <iostream>

#include "math/Vertex.hh"

namespace top10 {
  namespace racing {

    using top10::math::Vector;

    class StartingArea
    {
    public:
      StartingArea(Vector p1=Vector(0, 0, 0),
		   Vector p2=Vector(0, 0, 1),
		   Vector direction=Vector(1, 0, 0));
    
      void getStartingPos(int rank, Vector& pos, Vector& orientation) const;
    
      inline Vector getPoint1() const { return p1; }
      inline Vector getPoint2() const { return p2; }
      inline Vector getDirection() const { return direction; }

      inline void setPoint1(Vector p) { p1 = p; computeS(); } 
      inline void setPoint2(Vector p) { p2 = p; computeS(); }
      inline void setDirection(Vector d) { direction = d; computeS(); }

    private:
      Vector direction;
      Vector s1, s2;
      Vector p1, p2;

      void computeS();
    };
  };
  
};

#endif
