/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "StartingArea.hh"

using namespace top10::racing;
using namespace std;

StartingArea::StartingArea(Vector _p1, Vector _p2, Vector _direction):
  direction(_direction),
  p1(_p1), p2(_p2)
{
  computeS();
}

void StartingArea::computeS()
{
  s1 = (3*p1 + p2)/4 - direction*2;
  s2 = (p1 + 3*p2)/4 - direction*3;
}

void StartingArea::getStartingPos(int rank, Vector& pos, Vector& orientation) const
{
  const double spacing = 5.0;

  if (rank % 2) {
    pos = s2 - spacing*direction*rank;
  }
  else {
    pos = s1 - spacing*direction*rank;
  }
  orientation = direction;
}
