/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "LapRecordDb.hh"
#include <sstream>

namespace
{
  //! Return the longest prefix of s not containing "/" 
  std::string strip(const std::string& s)
  {
    std::string stripped;
    std::string::size_type pos = s.find("/");
    if (pos != std::string::npos)
      stripped = s.substr(0, pos);
    else
      stripped = s;

    return stripped;
  }
}

namespace top10
{
  namespace racing
  {

    LapRecordEntry::LapRecordEntry(const top10::racing::LapRecord lap,
				   const std::string& track_name,
				   const std::string& kart_name,
				   bool is_foggy,
				   bool is_saved):
    m_lap(lap),
      m_track_name(track_name),
      m_kart_name(kart_name),
      m_is_foggy(is_foggy),
      m_is_saved(is_saved)
    {
    }

    

    std::string LapRecordEntry::getRepr() const
    {
      std::ostringstream buf;
      
      // m_track_name is of the form "Track/Track.xml".
      // Keep only the first "Track"
      std::string track_name = strip(m_track_name);

      // m_kart_name is of the form "Kart/Kart".
      // Keep only the first "Kart"
      std::string kart_name = strip(m_kart_name);

      buf << "On " << track_name << " with " << kart_name << " on " << m_lap.getDate().getRepr();

      return buf.str();
    }

      
    top10::racing::LapRecord LapRecordEntry::getLap() const
    {
      return m_lap;
    }

    
    
    std::string LapRecordEntry::getTrackName() const
    {
      return m_track_name;
    }


    std::string LapRecordEntry::getKartName() const
    {
      return m_kart_name;
    }


    bool LapRecordEntry::isFoggy() const
    {
      return m_is_foggy;
    }



    /*
     * LapRecordDb
     */

    void LapRecordDb::addSavedLap(const std::string& filename)
    {
      //TODO
    }


    void LapRecordDb::addLap(const top10::racing::LapRecord& lap,
		             const std::string& track_name,
		             const std::string& kart_name,
			     bool foggy)
    {
      LapRecordEntry entry(lap, track_name, kart_name, foggy, false);
      m_entries.push_back(entry);
    }


    unsigned int LapRecordDb::getNumEntries() const
    {
      return m_entries.size();
    }


    LapRecordEntry LapRecordDb::getEntry(unsigned int idx) const
    {
      return m_entries.at(idx);
    }


    void LapRecordDb::saveLap(unsigned int)
    {
      //TODO
    }


    void LapRecordDb::discardLap(unsigned int)
    {
      //TODO
    }


    void LapRecordDb::deleteLap(unsigned int)
    {
      //TODO
    }

  }
}
