/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "KartTimer.hh"

using namespace top10::racing;
using namespace std;

KartTimer::KartTimer(const Kart* pkart, const CheckPoints* cps):
  kart(pkart),
  checkpoints(cps),
  next_checkpoint(cps->begin()),
  best_time(1000000),
  current_ms(0),
  first_time(true),
  starting_line_crossed(false),
  just_crossed_line(false)
{
}

void KartTimer::update(unsigned int dt)
{
  just_crossed_line = false;
  current_ms += dt;
  old_pos = current_pos;
  current_pos = kart->getPos();

  if (first_time) {first_time = false; return;}
  
  // Check if the next checkpoint was passed
  assert(!checkpoints->empty());
  if (next_checkpoint->checkPassed(old_pos, current_pos)) {

    // Starting line ?
    if (next_checkpoint == checkpoints->begin()) {
      just_crossed_line = true;

      // Add new lap
      if (starting_line_crossed) {
	unsigned int lap_time = current_ms - last_ms;
	lap_times.push_back(lap_time);
	if (lap_time < best_time || lap_times.empty()) {
	  best_time = lap_time;
	}
	cout<<" Lap time = "<<(lap_time/60000)<<":"<<((lap_time%60000)/1000)<<"."<<(lap_time%1000)<<endl;
      }
      else {
	starting_line_crossed = true;
      }

      last_ms = current_ms;
    }

    next_checkpoint++;
    cout<<"Checkpoint passed"<<endl;
    if (next_checkpoint == checkpoints->end()) {
      next_checkpoint = checkpoints->begin();
    }
  }
}
