/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "Action.hh"
#include <cassert>
#include <string>

std::istream& top10::racing::operator>>(std::istream& in, Action& action)
{
  std::string token;
  in>>token;
  
  if (token == "Steering") action = Steering;
  else if (token == "Acceleration") action = Acceleration;
  else if (token == "Braking") action = Braking;
  else if (token == "AccelerationAndBraking") action = AccelerationAndBraking;
  else if (token == "BrakingAndAcceleration") action = BrakingAndAcceleration;
  else if (token == "FreeCamH") action = FreeCameraHorizontal;
  else if (token == "FreeCamV") action = FreeCameraVertical;
  else if (token == "FreeCamX") action = FreeCameraMoveX;
  else if (token == "FreeCamZ") action = FreeCameraMoveZ;
  
  else if (token == "SteerLeft") action = SteerLeft;
  else if (token == "SteerRight") action = SteerRight;
  else if (token == "Accelerate") action = Accelerate;
  else if (token == "Brake") action = Brake;
  else if (token == "GearUp") action = GearUp;
  else if (token == "GearDown") action = GearDown;
  else if (token == "NextCamera") action = NextCamera;
  else if (token == "PrevCamera") action = PrevCamera;
  else if (token == "NextKart") action = NextKart;
  else if (token == "PrevKart") action = PrevKart;
  else if (token == "FreeCam") action = FreeCamera;
  else if (token == "ResetKart") action = ResetKart;
  //  else throw std::string("Invalid DigitalAction: ")+token;

  return in;
}

std::ostream& top10::racing::operator<<(std::ostream& out, Action action)
{
#define CASEOUT(e, t) case e: out<<t; break

  switch (action) {
    CASEOUT(Steering, "Steering");
    CASEOUT(Acceleration, "Acceleration");
    CASEOUT(Braking, "Braking");
    CASEOUT(AccelerationAndBraking, "AccelerationAndBraking");
    CASEOUT(BrakingAndAcceleration, "BrakingAndAcceleration");
    CASEOUT(FreeCameraHorizontal, "FreeCamH");
    CASEOUT(FreeCameraVertical, "FreeCamV");
    CASEOUT(FreeCameraMoveX, "FreeCamX");
    CASEOUT(FreeCameraMoveZ, "FreeCamZ");
    
    CASEOUT(SteerLeft, "SteerLeft");
    CASEOUT(SteerRight, "SteerRight");
    CASEOUT(Accelerate, "Accelerate");
    CASEOUT(Brake, "Brake");
    CASEOUT(GearUp, "GearUp");
    CASEOUT(GearDown, "GearDown");
    CASEOUT(NextCamera, "NextCamera");
    CASEOUT(PrevCamera, "PrevCamera");
    CASEOUT(NextKart, "NextKart");
    CASEOUT(PrevKart, "PrevKart");
    CASEOUT(FreeCamera, "FreeCam");
    CASEOUT(ResetKart, "ResetKart");
  default: assert(0);
  }

  return out;
#undef CASEOUT
}
