#include "ListPickSkel.hh"

#include <list>

namespace top10
{
  namespace qt
  {
    //! A widget allowing to edit a list of names.
    class ListPickWidget: public QWidget, private Ui::ListPickSkel
    {
      Q_OBJECT

    public:
      ListPickWidget(QWidget* parent =0);

      bool insertItemNoEmit(const std::string& item);
      bool removeItemNoEmit(const std::string& item);
      bool includeItemNoEmit(const std::string& item, bool insert_last = false);
      bool excludeItemNoEmit(const std::string& item);
      void clearNoEmit();
      void clearIncludedNoEmit();

    public slots:
      bool insertItem(const QString& item);
      bool removeItem(const QString& item);
      bool includeItem(const QString& item, bool insert_last = false);
      bool excludeItem(const QString& item);
      void clear();
      void clearIncluded();

    signals:
      void itemIncluded(int pos, const QString&);
      void itemExcluded(int pos, const QString&);
      void itemInserted(int pos, const QString&);
      void itemRemoved(const QString&);
      void cleared();
      void includedCleared();

    private:
      QListWidgetItem* takeItem(const QString& item, QListWidget* widget);
      bool removeItem(const QString& item, QListWidget* widget);

    private slots:
      void on_m_add_clicked();
      void on_m_remove_clicked();

    private:
      //! If true, emit signals.
      bool m_emit;
    };
  }
}
