#include "ComboBoxEditSkel.hh"

#include <list>

namespace top10
{
  namespace qt
  {
    class ComboBoxEdit: public QWidget, private Ui::ComboBoxEditSkel
    {
      Q_OBJECT

    public:
      ComboBoxEdit(QWidget* parent =0);

      bool insertItemNoEmit(const std::string& item);
      bool removeItemNoEmit(const std::string& item);
      bool setCurrentItemNoEmit(const std::string& item);
      bool setCurrentNameNoEmit(const std::string& name);
      void clearNoEmit();

    public slots:

      bool insertItem(const QString& item);
      bool removeItem(const QString& item);
      bool setCurrentItem(const QString& item);
      bool setCurrentName(const QString& name);
      void clear();

    signals:
      void itemInserted(const QString&);
      void itemRemoved(const QString&);
      void itemRenamed(const QString& new_name);
      void itemSelected(const QString&);
      void cleared();

    private slots:
      void on_m_new_clicked();
      void on_m_delete_clicked();
      void on_m_items_edited();
      void on_m_items_currentIndexChanged(const QString&);

    private:
      bool m_emit;
    };
  }
}
