#include "Integrator.hh"
#include <iostream>
#include <string>

namespace top10
{
  namespace tests
  {
    void testIntegrator()
    {
      using namespace top10::physX;

      DoubleState state;
      state.pos = 10.0;
      ConstantDoubleAccel gravity(-9.81);

      const double dt=0.1;
      for (double t=0; t < 1.0; t+=dt)
      {
	std::cout<<t<<": "<<state.pos<<" "<<state.speed<<"\n";
	integrate<DoubleState, DoubleDerivative, double, ConstantDoubleAccel>
	  (state, t, dt, gravity);
      }

      std::cout<<"Expected: "<<10.0-0.5*9.81<<"\n";
    }

    double dampedSpringAccel(top10::physX::DoubleState state, double t)
    {
      return -10.0 * (state.pos - 5.0) - 5.0 * state.speed;
    }

    void testIntegrator2()
    {
      using namespace top10::physX;

      DoubleState state;
      state.pos = 10.0;

      const double dt=0.1;
      for (double t=0; t < 10.0; t+=dt)
      {
	std::cout<<t<<": "<<state.pos<<" "<<state.speed<<"\n";
	integrate<DoubleState, DoubleDerivative, double, double(*)(DoubleState, double) >
	  (state, t, dt, dampedSpringAccel);
      }
    }
  }
}

int main(int argc, char** argv)
{
  top10::tests::testIntegrator2();
  std::string press_enter;
  std::cout<<"Press enter to exit."<<std::endl;
  std::cin>>press_enter;
  return 0;
}
