/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "World.hh"

using namespace top10::physX;
using namespace std;
const double World::G=9.81;
const unsigned int World::time_slice=1;

void World::simulate()
{
  double dt = time_slice/1000.0;
  
  for (vector<ComplexObject*>::iterator p = objects.begin();
       p != objects.end();
       ++p) {
    if ((*p)->isActive())
      (*p)->collideTrack(dt);
  }

  for (vector<ComplexObject*>::iterator p = objects.begin();
      p != objects.end();
      ++p) {
    if ((*p)->isActive()) {
      for (vector<FixedObject*>::iterator fixed_it = fixed_objects.begin();
          fixed_it != fixed_objects.end();
          ++fixed_it) {
        vector<top10::math::Triangle> tris = (*fixed_it)->getPotentialCollisions((*p)->getBoundingBox());
        (*p)->handleCollisions(tris, dt);
      }
    }
  }
      
  for (vector<ComplexObject*>::iterator p = objects.begin();
       p != objects.end();
       ++p) {
    if ((*p)->isActive())
      (*p)->update(G, dt);
  }

  for (vector<ComplexObject*>::iterator p = objects.begin();
       p != objects.end();
       ++p) {
    if ((*p)->isActive())
      (*p)->integrate(dt);
  }
}
