/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_PHYSX_WHEEL_STATE_HH
#define TOP10_PHYSX_WHEEL_STATE_HH

#include "WheelProperties.hh"
#include "RigidBodyState.hh"
#include "SurfacePatch.hh"

namespace top10
{
  namespace physX
  {
    class WheelState: public top10::util::RefCount
    {
    public:
      //! A wheel centered in (0,0,0) with it axis aligned with (0,0,1).
      WheelState(const WheelProperties*);

      //! Read/write accessor to the wheel seen as a rigid body.
      RigidBodyState* getRigidBody();

      //! Compute the forces applied by the ground and apply them on the rigid body of the wheel.
      void computeGroundForces(const SurfacePatch&, double load, WheelProperties::FrictionData* out_data =0);

    private:
      //! The properties of the weel.
      top10::util::Ref<const WheelProperties> m_props;

      //! A wheel is also a (not so) rigid body.
      top10::util::Ref<const RigidBodyProperties> m_rigid_props;

      //! Contains the orientation and velocities of the wheel.
      RigidBodyState m_rigid_state;
    };

    typedef top10::util::Ref<WheelState> WheelStateRef;
  }
}

#endif
