/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_PHYSX_SURFACE_PATCH_HH
#define TOP10_PHYSX_SURFACE_PATCH_HH

#include "math/Plane.hh"
#include "Surface.hh"

namespace top10 {
  namespace physX {

    class SurfacePatch: public Surface, public top10::math::Plane
    {
    public:
      SurfacePatch(const top10::math::Vector& p,
		   const top10::math::Vector& n,
		   const Surface& s):
	Surface(s),
	top10::math::Plane(p, n)
      {
      }

      SurfacePatch(const top10::math::Plane& plane,
		   const Surface& s):
	Surface(s),
	top10::math::Plane(plane)
      {
      }

      SurfacePatch() {};

    };

  };
};

#endif
