/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_PHYSX_SURFACE_HH
#define TOP10_PHYSX_SURFACE_HH

namespace top10 {
  namespace physX {
    
    struct Surface {
      Surface(double g, double d, double b, double r):
	grip(g), drag(d), bumps(b), response(r)
      {
      }

      Surface() {};

      /** Used to decide how slippery is a surface.
	  0.0 -> perfectly slippery
	  1.0 -> clean concrete
      */
      double grip;

      /** Some surfaces, like gravel/sand, have some drag factor,
	  ie drag is applied on the wheel, whatever the angular velocity
	  of the wheel */
      double drag;
		
      /** Bump factor of the triangle. Used for force feedback */
      double bumps;

      //! Used for collision response. Must between 0 (full absorption) and 1 (full response)
      double response;
    };

    struct SurfaceConcrete: public Surface {
      SurfaceConcrete();
    };

    struct SurfaceDust: public Surface {
      SurfaceDust();
    };

    struct SurfaceDirt: public Surface {
      SurfaceDirt();
    };

    struct SurfaceGrass: public Surface {
      SurfaceGrass();
    };

    struct SurfaceSand: public Surface {
      SurfaceSand();
    };

    struct SurfaceBorder: public Surface {
      SurfaceBorder();
    };

    struct SurfaceSlip: public Surface {
      SurfaceSlip(): Surface(0,0,0,1.0) {}
    };
    
  };
};

#endif
