/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "SpringManager.hh"

namespace top10
{
  namespace physX
  {
    void SpringManager::addLinearSpring(LinearSpring* spring)
    {
      m_linear_springs.push_back( LinearSpringRef(spring) );
    }

    void SpringManager::addAngularSpring(AngularSpring* spring)
    {
      m_angular_springs.push_back( AngularSpringRef(spring) );
    }

    void SpringManager::applyForces()
    {
      for (int i=0; i<m_linear_springs.size(); ++i)
	m_linear_springs[i]->applyForces();

      for (int i=0; i<m_angular_springs.size(); ++i)
	m_angular_springs[i]->applyForces();
    }
  }
}
