#ifndef TOP10_SETUP_SETTING_HH
#define TOP10_SETUP_SETTING_HH

#include "util/XmlDumpable.hh"
#include "util/RefCount.hh"

namespace top10
{
  namespace physX
  {



    struct TyreSetting: public top10::util::XmlDumpable
    {
      TyreSetting();
      TyreSetting(double, double, double, const char*);

      double m_side_k;
      double m_long_k;
      double m_breadth;
      std::string m_desc;

      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

    private:
      static const char* s_nodename;
    };




    struct EngineSetting: public top10::util::XmlDumpable
    {
      EngineSetting();
      EngineSetting(double, const char*);

      double m_opt;
      std::string m_desc;

      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

    private:
      static const char* s_nodename;
    };




    struct StiffSetting: public top10::util::XmlDumpable
    {
      StiffSetting();
      StiffSetting(double, const char*);

      double m_stiff;
      std::string m_desc;

      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

    private:
      static const char* s_nodename;
    };



    struct Settings: public top10::util::XmlDumpable,
		     public top10::util::RefCount
    {
      Settings();

      std::vector<TyreSetting> m_tyre_settings;      
      std::vector<EngineSetting> m_engine_settings;
      std::vector<StiffSetting> m_stiff_settings;

      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

    private:
      static const char* s_nodename;
    };



    struct SettingsState
    {
      enum Components
      {
	COMP_FRONT_TYRE_STICKYNESS = 0,
	COMP_REAR_TYRE_STICKYNESS = 1,
	COMP_ENGINE_USAGE = 2,
	COMP_FRONT_STIFFNESS = 3,
	COMP_REAR_STIFFNESS = 4
      };

      static const Components COMP_FIRST = COMP_FRONT_TYRE_STICKYNESS;;
      static const Components COMP_LAST = COMP_REAR_STIFFNESS;

      SettingsState();

      std::string getDesc(Components) const;

      void incr(Components);
      void decr(Components);

      top10::util::Ref<const Settings> m_settings;
      unsigned int m_idxs[5];

    private:
      unsigned int getNumSettings(Components c) const;
    };



    std::string getStr(SettingsState::Components);
  }
}
#endif
