/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_PHYSX_LINEAR_SPRING_PROPS_HH
#define TOP10_PHYSX_LINEAR_SPRING_PROPS_HH

#include "util/RefCount.hh"
#include "util/XmlDumpable.hh"
#include "math/Vertex.hh"

namespace top10
{
  namespace physX
  {
    //! A linear spring and damper.
    class LinearSpringProperties: public top10::util::RefCount, public top10::util::XmlDumpable
    {
    public:
      static const char* NODE_NAME;

    public:
      LinearSpringProperties();

      void setStiffness(double);
      void setLength(double);
      void setDamping(double);

      //! Return the force from the spring on one end of the spring.
      /*!
	\param diff Vector from one end of the spring to the other.
	\param speed Speed of the end with respect to the origin of the spring.
	\return The force of the spring applied on the end.
      */
      top10::math::Vector getForce(top10::math::Vector diff,
				   top10::math::Vector speed) const;

    protected:
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;
      void clearState();

    private:
      //! The length at rest
      double m_length;

      //! The stiffness coefficient
      double m_stiffness;

      //! The damping coefficient
      double m_damping;
    };

    typedef top10::util::Ref< LinearSpringProperties > LinearSpringPropertiesRef;
    typedef std::vector< LinearSpringPropertiesRef > LinearSpringPropertiesRefs;
  }
}

#endif
