/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "LinearSpring.hh"

namespace top10
{
  namespace physX
  {
    LinearSpring::LinearSpring()
    {
    }

    void LinearSpring::setProperties(const LinearSpringProperties* props)
    {
      m_props = props;
    }

    void LinearSpring::setBody1(RigidBodyState* body1, top10::math::Vector attach1)
    {
      m_body1 = body1;
      m_attach1 = attach1;
    }

    void LinearSpring::setBody2(RigidBodyState* body2, top10::math::Vector attach2)
    {
      m_body2 = body2;
      m_attach2 = attach2;
    }

    void LinearSpring::applyForces()
    {
      if (!m_props.isValid() || !m_body1.isValid() || !m_body2.isValid())
	return;

      const top10::math::Vector pos1 = m_body1->localToGlobal(m_attach1);
      const top10::math::Vector pos2 = m_body2->localToGlobal(m_attach2);

      const top10::math::Vector speed1 = m_body1->getSpeedAtL(m_attach1);
      const top10::math::Vector speed2 = m_body2->getSpeedAtL(m_attach2);

      const top10::math::Vector force = m_props->getForce( pos2 - pos1, speed2 - speed1 );
      
      m_body2->applyForceAt(pos2, force);
      m_body1->applyForceAt(pos1, -force);
    }
  }
}
