/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_PHYSX_KART_STATE_HH
#define TOP10_PHYSX_KART_STATE_HH

#include "KartProperties.hh"
#include "EngineState.hh"
#include "GearBoxState.hh"
#include "ClutchState.hh"
#include "AxleState.hh"
#include "RigidBodyState.hh"
#include "WheelState.hh"
#include "LinearSpring.hh"
#include "AngularSpring.hh"

class EngineTestDlg;

namespace top10
{
  namespace physX
  {
    //! Groups the state of all components of a go-kart.
    class KartState
    {
    public:
      KartState(const KartProperties*);

      void setClutch(bool);
      void setThrottle(double);
      void setGear(int);

      //! Compute and apply forces due to the drivetrain.
      void applyForces(double t, double dt);

      //! Update the state of the drivetrain.
      void integrate(double t, double dt);

      EngineState getEngine() const;
      GearBoxState getGearBox() const;
      ClutchState getClutch() const;
      AxleState getAxle() const;

    private:
      void updateDriveTrain(double t, double dt, EngineState* new_engine, AxleState* new_axle);

    private:
      RigidBodyStateRefs m_bodies;
      LinearSpringRefs m_lin_springs;
      AngularSpringRefs m_ang_springs;
      std::vector<WheelState> m_wheels;

      EngineState m_engine;
      GearBoxState m_gear_box;
      ClutchState m_clutch;
      AxleState m_axle;

      friend class ::EngineTestDlg;
    };
  }
}

#endif
