/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "GearBoxState.hh"
#include <cmath>

namespace top10
{
  namespace physX
  {
    GearBoxState::GearBoxState(const GearBoxProperties* props)
      : m_props(props), m_ratio(0.0), m_gear(0), m_torque_in(0.0), m_wspeed_out(0.0)
    {
    }

    void GearBoxState::setGear(int g)
    {
      if (m_props->isValid(g))
      {
	m_gear = g;
	m_ratio = m_props->getRatio(g);
      }
    }

    void GearBoxState::gearUp()
    {
      if (m_props->isValid(m_gear + 1))
	setGear(m_gear +1);
    }

    void GearBoxState::gearDown()
    {
      if (m_props->isValid(m_gear -1))
	setGear(m_gear -1);
    }

    bool GearBoxState::isCoupled() const
    {
      return fabs(m_ratio) > 0.0001;
    }

    double GearBoxState::getRatio() const
    {
      return m_ratio;
    }
  }
}
