/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_ENGINE_STATE_HH
#define TOP10_ENGINE_STATE_HH

#include "EngineProperties.hh"

namespace top10
{
  namespace physX
  {
    //! The state of an engine is its RPM and the throttle.
    /*! Then engine generates a torque. */
    class EngineState
    {
    public:
      EngineState(const EngineProperties*);

      void setThrottle(double);
      void setWSpeed(double);
      double getWSpeed() const;
      double getTorque() const;
      double getInertia() const;

    private:
      //! The properties of this engine.
      top10::util::Ref<const EngineProperties> m_props;

      //! A number between 0.0 and 1.0 representing the position of the gas pedal
      double m_throttle;
      
      //! Angular velovity, in rad/s
      double m_wspeed;
    };
  }
}

#endif
