/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_ENGINE_PROPERTIES_HH
#define TOP10_ENGINE_PROPERTIES_HH

#include "util/RefCount.hh"
#include "math/Curve.hh"
#include "util/XmlDumpable.hh"

namespace top10
{
  namespace physX
  {
    //! The properties of an engine are its idle and full-throttle power curves, and its inertia.
    class EngineProperties : public top10::util::RefCount, public top10::util::XmlDumpable
    {
    public:
      static const char* NODE_NAME;

    public:
      EngineProperties();

      void addPointThrottle(double rad_per_sec, double torque);
      void addPointIdle(double rad_per_sec, double torque);

      double getTorque(double throttle, double rad_per_sec) const;
      double getInertia() const;
      void clearState();

    protected:
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;

    private:
      //! The power curve under full throttle.
      top10::math::Curve2D m_curve_throttle;
      //! The idle power curve.
      top10::math::Curve2D m_curve_idle;
      //! The inertia of the engine.
      double m_inertia;
    };
  }
}

#endif
