/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "ClutchState.hh"

namespace top10
{
  namespace physX
  {
    ClutchState::ClutchState(const ClutchProperties* props)
      : m_engaged(false),
	m_speed(0.0),
	m_props(props)
    {
    }


    void ClutchState::setWSpeed(double speed)
    {
      m_speed = speed;
    }

    double ClutchState::getWSpeed() const
    {
      return m_speed;
    }

    double ClutchState::getFriction() const
    {
      return m_engaged ? m_props->getFriction() : 0.0;
    }

    void ClutchState::toggle(bool b)
    {
      m_engaged = b;
    }

    bool ClutchState::isEngaged() const
    {
      return m_engaged;
    }
  }
}
