/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "ClutchProperties.hh"

namespace top10
{
  namespace physX
  {
    const char* ClutchProperties::NODE_NAME = "clutch_properties";

    ClutchProperties::ClutchProperties()
      : top10::util::XmlDumpable(NODE_NAME),
      m_friction(0.0)
    {
    }

    void ClutchProperties::setFriction(double f)
    {
      m_friction = f;
    }

    double ClutchProperties::getFriction() const
    {
      return m_friction;
    }

    int ClutchProperties::loadXml(const TiXmlElement* node)
    {
      int status = 0;
      status = node->QueryDoubleAttribute("friction", &m_friction);
      return status;
    }

    int ClutchProperties::saveXml(TiXmlElement* node) const
    {
      int status = 0;
      node->SetDoubleAttribute("friction", m_friction);
      return status;
    }

    void ClutchProperties::clearState()
    {
      m_friction = 0.0;
    }
  }
}
