/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "AxleProperties.hh"

namespace top10
{
  namespace physX
  {
    const char* AxleProperties::NODE_NAME = "axle_properties";

    AxleProperties::AxleProperties()
      : top10::util::XmlDumpable(NODE_NAME),
      m_inertia(0.0)
    {
    }

    void AxleProperties::setInertia(double inertia)
    {
      m_inertia = inertia;
    }

    double AxleProperties::getInertia() const
    {
      return m_inertia;
    }

    void AxleProperties::clearState()
    {
      m_inertia = 0.0;
    }

    int AxleProperties::loadXml(const TiXmlElement* node)
    {
      int status = 0;
      status = node->QueryDoubleAttribute("inertia", &m_inertia);
      return status;
    }

    int AxleProperties::saveXml(TiXmlElement* node) const
    {
      node->SetDoubleAttribute("inertia", m_inertia);
      return 0;
    }
  }
}
