/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_PHYSX_ANGULAR_SPRING_PROPS_HH
#define TOP10_PHYSX_ANGULAR_SPRING_PROPS_HH

#include "util/RefCount.hh"
#include "util/XmlDumpable.hh"
#include "math/Vertex.hh"

namespace top10
{
  namespace physX
  {
    //! An angular spring and damper, generates a torque instead of a force.
    class AngularSpringProperties: public top10::util::RefCount, public top10::util::XmlDumpable
    {
    public:
      static const char* NODE_NAME;

    public:
      AngularSpringProperties();

      void setStiffness(double);
      void setDamping(double);

      //! Return the torque.
      /*!
	\param ref The reference unit-vector.
	\param dir The direction unit-vector.
	\param w_speed The angular velocity.
	\return The torque bringing dir towards ref.
      */
      top10::math::Vector getTorque(top10::math::Vector ref,
	                            top10::math::Vector dir,
				    top10::math::Vector w_speed) const;

    protected:
      int loadXml(const TiXmlElement*);
      int saveXml(TiXmlElement*) const;
      void clearState();

    private:
      //! The stiffness coefficient, in N.m/rad
      double m_stiffness;

      //! The damping coefficient, in N.m.s/rad
      double m_damping;
    };

    typedef top10::util::Ref< AngularSpringProperties > AngularSpringPropertiesRef;
    typedef std::vector< AngularSpringPropertiesRef > AngularSpringPropertiesRefs;
  }
}

#endif
