/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_ANGULAR_SPRING_HH
#define TOP10_ANGULAR_SPRING_HH

#include "AngularSpringProperties.hh"
#include "RigidBodyState.hh"

namespace top10
{
  namespace physX
  {
    class AngularSpring: public top10::util::RefCount
    {
    public:
      AngularSpring();

      //! Set the properties of the spring (stiffness and damping).
      void setProperties(const AngularSpringProperties*);

      //! Attach a body to this spring.
      /*!
	\param direction Unit vector selecting the reference direction in the body's frame.
      */
      void setBody1(RigidBodyState*, top10::math::Vector direction);

      //! \see setBody1
      void setBody2(RigidBodyState*, top10::math::Vector direction);

      //! Compute forces due to the spring and apply them to the bodies.
      /*!
	Does nothing if this spring is not attached to two bodies or the properties were not set.
	*/
      void applyForces();

    private:

      //! The properties of this spring.
      top10::util::Ref<const AngularSpringProperties> m_props;

      //! The first body to which this spring is attached.
      top10::util::Ref<RigidBodyState> m_body1;

      //! The first body to which this spring is attached.
      top10::util::Ref<RigidBodyState> m_body2;

      //! The reference direction, in the frame of m_body1
      top10::math::Vector m_dir1;

      //! The reference direction, in the frame of m_body2
      top10::math::Vector m_dir2;
    };

    typedef top10::util::Ref< AngularSpring > AngularSpringRef;
    typedef std::vector< AngularSpringRef > AngularSpringRefs;

  }
}

#endif
