/*
  Top 10, a racing simulator
  Copyright (C) 2003-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "AngularSpring.hh"

namespace top10
{
  namespace physX
  {
    AngularSpring::AngularSpring()
    {
    }

    void AngularSpring::setProperties(const AngularSpringProperties* props)
    {
      m_props = props;
    }

    void AngularSpring::setBody1(RigidBodyState* body1, top10::math::Vector dir)
    {
      m_body1 = body1;
      m_dir1 = dir;
    }

    void AngularSpring::setBody2(RigidBodyState* body2, top10::math::Vector dir)
    {
      m_body2 = body2;
      m_dir2 = dir;
    }

    void AngularSpring::applyForces()
    {
      if (!m_props.isValid() || !m_body1.isValid() || !m_body2.isValid())
	return;

      const top10::math::Vector dir1 = m_body1->getOrient() * m_dir1;
      const top10::math::Vector dir2 = m_body2->getOrient() * m_dir2;

      const top10::math::Vector w_speed1 = m_body1->getOrient() * m_body1->getWSpeed();
      const top10::math::Vector w_speed2 = m_body2->getOrient() * m_body2->getWSpeed();

      const top10::math::Vector torque = m_props->getTorque(m_dir1, m_dir2, w_speed2 - w_speed1);
      
      m_body1->applyTorque(-torque);
      m_body2->applyTorque(torque);
    }
  }
}
