/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Vertex.hh"
#include "math/Vec2D.hh"

using top10::math::Vector;

void Vector::dumpTo(std::ostream& str) const
{
  output<double>(str, x);
  output<double>(str, y);
  output<double>(str, z);
}

void Vector::loadFrom(std::istream& str)
{
  input<double>(str, x);
  input<double>(str, y);
  input<double>(str, z);
}

void Vector::loadXml(const TiXmlElement* el)
{
  assert(el);
  Vector tmp;
  int status;
  status = el->QueryDoubleAttribute("x", &tmp.x);
  if (status != TIXML_SUCCESS) throw std::string("Could not read X coordinate");
  status = el->QueryDoubleAttribute("y", &tmp.y);
  if (status != TIXML_SUCCESS) throw std::string("Could not read Y coordinate");
  status = el->QueryDoubleAttribute("z", &tmp.z);
  if (status != TIXML_SUCCESS) throw std::string("Could not read Z coordinate");
  *this = tmp;
}

void Vector::saveXml(TiXmlElement* el) const
{
  assert(el);
  el->SetDoubleAttribute("x", x);
  el->SetDoubleAttribute("y", y);
  el->SetDoubleAttribute("z", z);
}


bool top10::math::cross(Vector p1, Vector d1, Vector p2, Vector d2)
{
  using top10::math::Vec2D;
  
  Vec2D pp1(p1.x, p1.z);
  Vec2D dd1(d1.x, d1.z);
  Vec2D pp2(p2.x, p2.z);
  Vec2D dd2(d2.x, d2.z);
  
  return segment_intersection(pp1, dd1, pp2, dd2);
}
