/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_MATHOUTLINE_HH
#define TOP10_MATHOUTLINE_HH

#include "Mesh.hh"
#include <list>
#include <map>

namespace top10 {
namespace math {

class Outline {
  static const double EPS;
  
public:
  struct Edge {
    Edge(const top10::math::Vector& _p1,  const top10::math::Vector& _p2): p1(_p1), p2(_p2)
    {
    }
          
    top10::math::Vector p1;
    top10::math::Vector p2;
  };

public:  
  Outline(const Mesh* mesh);

  //! Compute the outline of a mesh, as seen from a specified position
  /*! The position of the viewer is expressed in local coordinates */
  std::list<Edge> compute(Vector viewer) const;
  
  inline const Mesh* getMesh() const { return mesh; }

  //! Turn a list of edges into a loop of vertices.
  static std::list<top10::math::Vector>
    sort(const std::list<Edge>&);

  //! Simplify a loop of vertices
  static void simplify(std::list<top10::math::Vector>*, double mindist2);

private:
  const Mesh* mesh;
};

}
}

#endif
