/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_KARTED_MAINWIN_HH
#define TOP10_KARTED_MAINWIN_HH

#include "MainWindowSkel.hh"
#include "util/RefCount.hh"
#include "physX/KartProperties.hh"

#include <QtCore/QString>
#include <QtGui/QMainWindow>

class MainWindow: public QMainWindow, public Ui::MainWindowSkel
{
  Q_OBJECT

public:
  MainWindow();

public slots:
  void menuOpen();
  void menuSave();
  void menuSaveAs();
  void menuQuit();

private:
  QString m_filename;
  top10::util::Ref<top10::physX::KartProperties> m_props;
};

#endif
