/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "MainWindow.hh"
#include <QtGui/QFileDialog>
#include <QtGui/QMessageBox>

MainWindow::MainWindow()
{
  m_props = new top10::physX::KartProperties;
  setupUi(this);

  connect(actionOpen, SIGNAL(triggered()), SLOT(menuOpen()));
  connect(actionSave, SIGNAL(triggered()), SLOT(menuSave()));
  connect(actionSave_As, SIGNAL(triggered()), SLOT(menuSaveAs()));
  connect(actionQuit, SIGNAL(triggered()), SLOT(menuQuit()));
}

void MainWindow::menuOpen()
{
  QString fn = QFileDialog::getOpenFileName(this);
  if (!fn.isEmpty())
  {
    try {
      top10::util::Ref< top10::physX::KartProperties > props(new top10::physX::KartProperties);
      TiXmlDocument doc(fn.toStdString());
      const TiXmlElement* top_el = doc.RootElement();

      if (top_el)
	props->load(top_el);
      else
	throw std::string("Failed to load ") + fn.toStdString();

      m_props = props;
    }
    catch (const std::string& err)
    {
      QMessageBox::warning(this, "File error", err.c_str());
    }
  }
}




void MainWindow::menuSaveAs()
{
  QString fn = QFileDialog::getSaveFileName(this);
  if (!fn.isEmpty())
  {
    m_filename = fn;
    menuSave();
  }
}




void MainWindow::menuSave()
{
  if (m_filename.isEmpty())
  {
    menuSaveAs();
    return;
  }

  try {
    top10::util::Ref< top10::physX::KartProperties > props(new top10::physX::KartProperties);

    TiXmlDocument doc(m_filename.toStdString());

    TiXmlElement top_el("");;
    props->save(&top_el);

    TiXmlElement* root = doc.RootElement();
    if (root)
      doc.RemoveChild(root);

    doc.InsertEndChild(top_el);
    doc.SaveFile(m_filename.toStdString());
  }
  catch (const std::string& err)
  {
    QMessageBox::warning(this, "File error", err.c_str());
  }
}




void MainWindow::menuQuit()
{
  close();
}




