/*
  Top10, a racing simulator
  Copyright (C) 2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef _TOP10_INITAL_HH
#define _TOP10_INITAL_HH

#include <al.h>
#include <alc.h>
#include <string>

namespace top10
{
  namespace helpers
  {
    //! Class keeping track of the audio context.
    class AudioContext
    {
    public:
      static AudioContext* getSingle();
      static AudioContext* getSingle(const char* device_name);
      ~AudioContext();

    private:
      AudioContext();

      ALCdevice* dev;
      ALCcontext* context;

      static AudioContext* single;
    };

    //! Initialize openAL, opening the default device, whatever that is.
    AudioContext* initAL();
    
    //! Initialize openAL, opening the specified device.
    AudioContext* initAL(const char* device_name);

    void closeAL(AudioContext*);

    std::string makeErrorStr(ALenum);
  };
};

#endif