/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_HELPERSREADCAL3D_HH
#define TOP10_HELPERSREADCAL3D_HH

#include <cal3d/cal3d.h>
#include <fstream>

#include "graphX/Node.hh"
#include "graphX/GroupNode.hh"
#include "util/PathFinder.hh"
#include "util/RefCount.hh"

namespace top10 {
namespace helpers {

class ReadCal3d {
public:
  ReadCal3d(std::string filename);

  inline top10::graphX::Node* getTopNode() { return top_node.getPtr(); }
  
  ~ReadCal3d();

private:
  void parseCfg(std::ifstream& file);
  void import();
  
  CalCoreModel* m_calCoreModel;
  top10::util::PathFinder finder;
  top10::util::Ref<top10::graphX::GroupNode> top_node;
  
  float m_scale;
  
};

}
}

#endif
