/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#include "MeshFactory.hh"
#include "util/PathFinder.hh"

#include "3dsRead.hh"
#include "ReadCal3d.hh"

top10::helpers::MeshFactory* top10::helpers::MeshFactory::single = 0;

top10::helpers::MeshFactory* top10::helpers::MeshFactory::getSingle( )
{
  if (!single) single = new MeshFactory;
  return single;
}

top10::graphX::Node* top10::helpers::MeshFactory::load( std::string filename )
{
  int pos = filename.rfind(".");
  std::string ext;
  if (pos >= 0 && pos < (int)filename.size()) {
    ext = filename.substr(pos, filename.size()-pos);
  }
  
  std::string path = top10::util::PathFinder::defaultPathFinder().find(filename);
  if (path.empty()) throw FileNotFound(filename);
  
  if (ext == ".3ds") {
    Read3DS reader(path);
    return reader.getTopNode();
  }
  else {
    ReadCal3d reader(path);
    return reader.getTopNode();
  }
  
  return 0;
}

top10::helpers::MeshFactory::FileNotFound::FileNotFound( std::string filename ):
    top10::util::Error(filename + " not found")
{
  
}

