/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXWIREFRAME_HH
#define TOP10_GRAPHXWIREFRAME_HH

#include "NodeProxy.hh"
#include "MeshNode.hh"

namespace top10 {
namespace graphX {

//! Draw children meshes in wireframe mode
class Wireframe: public Node
{
public:
  Wireframe();
  
  inline void setThickness(float f) { thickness = f; }
  
  Node* getChild(int idx) const;
  void addChild(Node*);
  void removeChild(Node*);
  void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const;
  
protected:
  void modifyRenderState(RenderState& s, const CameraNode&) const;

private:
  //! Renders a mesh node using lines
  class WireframeMesh: public LeafNode {
  public:
    WireframeMesh(const MeshNode* original):orig(original) {}
    void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const;
  
  private:
    top10::util::Ref<const MeshNode> orig;    
  };
  
  class MyProxyOperation: public ProxyOperation {
  public:
    Node* makeChild(const MeshNode*) const;   
  };

private:
  float thickness;  
  //! Nodes added with addChild
  NodeRefs originals;
  //! Nodes created in addChild
  NodeRefs children;
  //! Used to duplicate MeshNodes with WireframeMeshes
  top10::util::Ref<MyProxyOperation> my_op;
};

//! Draw children meshes, by changing the fill mode of polygons
class WireframeFill: public GroupNode
{
public:
  WireframeFill(): thickness(1.0) {}
  inline void setThickness(float f) { thickness = f; }
  
protected:
  void modifyRenderState(RenderState& s, const CameraNode&) const;
  
private:
  float thickness;
};

}
}

#endif
