/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "WireNode.hh"

namespace top10 {
namespace graphX {

void WireNode::addWire(const top10::math::Vector& v1, const top10::math::Vector& v2)
{
  wires.push_back( std::make_pair(v1, v2) );
}

void WireNode::renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const
{
  glBegin(GL_LINES);
  for (std::list< std::pair< top10::math::Vector, top10::math::Vector > >::const_iterator it = wires.begin();
       it != wires.end();
       ++it)
  {
    glVertex3f(it->first.x, it->first.y, it->first.z);
    glVertex3f(it->second.x, it->second.y, it->second.z);
  }
  glEnd();
}

WireNode* WireNode::makeBox(const top10::math::AxisAlignedBox& box)
{
    WireNode* ret = new WireNode;

    top10::math::Vector vertices[8];
    box.getVertices(vertices);

    int face[][4] = {{0,1,3,2},
		     {4,5,7,6},
		     {0,1,5,4},
		     {2,3,7,6}};

    for (int j=0; j<4; ++j)
	for (int i=0; i<4; ++i)
	    ret->addWire(vertices[face[j][i]], vertices[face[j][(i+1)%4]]);

    return ret;
}
}
}
