/*
  Top10, a racing simulator
  Copyright (C) 2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_GRAPHX_TEXTURE_UNIT_HH
#define TOP10_GRAPHX_TEXTURE_UNIT_HH

#include "GroupNode.hh"
#include "RenderState.hh"

namespace top10
{
namespace graphX
{
  //! Set the texture unit that children nodes affecting the texture state will use.
  class TextureUnit: public GroupNode
  {
  public:
    TextureUnit();

    void setUnit(int);

  protected:
    void modifyRenderState(RenderState& s, const CameraNode&) const;

  private:
    int unit;
  };

}
}

#endif