/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_GRAPHX_TEXTURENODE_HH
#define TOP10_GRAPHX_TEXTURENODE_HH

#include "GroupNode.hh"
#include "RenderState.hh"
#include "CubeMap.hh"

namespace top10 {
  namespace graphX {

    //! Texture to use for texture mapping.
    /*! Applies to all children */
    class TextureNode: public GroupNode {
    public:      
      TextureNode();

      //! Set the texture mode
      void setEnvMode(RenderState::TexEnvMode);

      //! Set the id of a 2D texture
      void setTextureId(unsigned int texture_object_id);

      //! Set the id of CubeMap
      void setCubeMap(const CubeMap&);

      //! Set filtering
      void setFiltering(RenderState::Filtering);

    protected:
      void modifyRenderState(RenderState& s, const CameraNode&) const;

    private:
      RenderState::TexEnvMode mode;
      bool use_cube_map;
      unsigned int texture_id;
      RenderState::Filtering filtering;
    };

  };
};

#endif
