/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "TextureNode.hh"

namespace top10
{
namespace graphX
{

  TextureNode::TextureNode()
    : mode(RenderState::Modulate), use_cube_map(false), texture_id(0), filtering(RenderState::Linear)
  {
  }

  void TextureNode::setEnvMode(RenderState::TexEnvMode m)
  {
    mode = m;
  }

  void TextureNode::setTextureId(unsigned int id)
  {
    use_cube_map = false;
    texture_id = id;
  }

  void TextureNode::setCubeMap(const CubeMap& cube)
  {
    use_cube_map = true;
    texture_id = cube.getId();
  }

  void TextureNode::setFiltering(RenderState::Filtering f)
  {
    filtering = f;
  }

  void TextureNode::modifyRenderState(RenderState& s, const CameraNode&) const
  {
    if (use_cube_map)
      s.setCubeMapId(texture_id);
    else
      s.setTextureId(texture_id);

    s.setTexEnv(mode);

    s.setFiltering(filtering);
  }

}
}
